const express = require("express");
const axios = require("axios");
const jwt = require("jsonwebtoken");
require("dotenv").config();
const querystring = require("querystring");

const app = express();
const port = 3000;

app.use(express.urlencoded({ extended: true }));
app.use(express.static("public")); // Serve static files from the 'public' directory

// Home route
app.get("/", (req, res) => {
  res.sendFile(__dirname + "/public/index.html");
});

// Login route
app.get("/login", (req, res) => {
  const authUrl = `${process.env.AUTH_URL}?response_type=code&client_id=${process.env.CLIENT_ID}&redirect_uri=${process.env.REDIRECT_URI}&scope=profile`;
  res.redirect(authUrl);
});

// Callback route -> This route can be changed based on the custom OIDC/OpenId application such as loginWithIDP
app.get("/callback", async (req, res) => {
  const code = req.query.code;

  try {
    const response = await axios.post(
      process.env.TOKEN_URL,
      querystring.stringify({
        code: code,
        client_id: process.env.CLIENT_ID,
        client_secret: process.env.CLIENT_SECRET,
        redirect_uri: process.env.REDIRECT_URI,
        grant_type: "authorization_code",
      }),
      { headers: { "Content-Type": "application/x-www-form-urlencoded" } }
    );

    const token = response.data.access_token;
    const userInfo = jwt.decode(token);

    res.send(
      `<h1>Welcome ${userInfo.name}</h1><p>${JSON.stringify(
        userInfo
      )}</p><a href="/about">Go to About</a>`
    );
  } catch (error) {
    console.error(error);
    res.status(500).send("Authentication failed");
  }
});

// About route
app.get("/about", (req, res) => {
  res.send("<h1>About Page</h1><p>This is the about page.</p>");
});

app.listen(port, () => {
  console.log(`Server is running on http://localhost:${port}`);
});
